# Create occupational class variable from primary and secondary
# occupational categories as used in GLES waves since 2009 

BerufClass09 <- function(BerufHaupt,
                         BerufNArbeiter,
                         BerufNAngestellt,
                         BerufNBeamter
                         ){
  cases(
    "Manuelle Arbeit" = (BerufHaupt == 6 & BerufNArbeiter %in% 1:3),
    "Vorarbeiter" = (BerufHaupt == 6 & BerufNArbeiter %in% 4:5),
    "Nichtmanuelle Routine"=(BerufHaupt == 5 & BerufNAngestellt %in% 2:3 |
                            BerufHaupt == 4 & BerufNBeamter %in% 1:2
    ),
    "Untere Dienstklasse"=(BerufHaupt == 5 & BerufNAngestellt %in% c(1,4) |
                             BerufHaupt == 4 & BerufNBeamter == 3
    ),
    "Obere Dienstklasse"=(BerufHaupt == 5 & BerufNAngestellt == 5 |
                             BerufHaupt == 4 & BerufNBeamter == 4
    ),
    "Selbständig"=(BerufHaupt %in% 2:3),
    "Landwirtsch. Beruf"=(BerufHaupt == 1)
  )
}

BerufClass05 <- function(BerufStellung,
                         Arbeiter,
                         Angestellte,
                         Beamte){
  cases(
    "Manuelle Arbeit" = (BerufStellung == 1 & Arbeiter %in% 1:3),
    "Vorarbeiter" = (BerufStellung == 1 & Arbeiter %in% 4:5),
    "Nichtmanuelle Routine"=(BerufStellung == 2 & Angestellte %in% 1:2 |
                            BerufStellung == 3 & Beamte %in% 1:2
    ),
    "Untere Dienstklasse"=(BerufStellung == 2 & Angestellte %in% c(3,5) |
                             BerufStellung == 3 & Beamte == 3
    ),
    "Obere Dienstklasse"=(BerufStellung == 2 & Angestellte == 4 |
                             BerufStellung == 3 & Beamte == 4
    ),
    "Selbständig"=(BerufStellung %in% 5:7),
    "Landwirtsch. Beruf"=(BerufStellung == 4)
  )
}

BerufClass13 <- function(Beruf){
  recode(Beruf,
                  "Manuelle Arbeit"       = 1 <- 11:12,
                  "Vorarbeiter"           = 2 <- c(13,21),
                  "Nichtmanuelle Routine" = 3 <- c(22:23,31:32),
                  "Untere Dienstklasse"   = 4 <- c(24,33),
                  "Obere Dienstklasse"    = 5 <- c(25,34),
                  "Selbständig"           = 6 <- c(41:43,51:53),
                  "Landwirtsch. Beruf"    = 7 <- 61
  )
}
